"use strict";
var Log = require("./models/Log");
var nodemailer = require('nodemailer');
var smtpTransport = require('nodemailer-smtp-transport');
var Config = require("./models/Config");
function log(message) {
    var l = new Log();
    l.timestamp = new Date();
    l.message = message;
    l.save();
}
exports.log = log;
function sendEmail(subject, body, config, cb) {
    if (config.smtp_host != '') {
        var smtpOptions = {};
        smtpOptions.host = config.smtp_host;
        smtpOptions.port = config.smtp_port;
        smtpOptions.ignoreTLS = !config.smtp_secure;
        if (config.smtp_username != '' || config.smtp_password != '') {
            smtpOptions.auth = {
                user: config.smtp_username,
                pass: new Buffer(config.smtp_password, 'base64').toString()
            };
        }
        if (config.smtp_local_hostname != '') {
            smtpOptions.name = config.smtp_local_hostname;
        }
        var transporter = nodemailer.createTransport(smtpTransport(smtpOptions));
        // setup e-mail data with unicode symbols
        var mailOptions = {
            from: config.smtp_from_address,
            to: config.smtp_to_address,
            subject: subject,
            text: body
        };
        // send mail with defined transport object
        if ('development' == global["app"].get('env')) {
            log("Sent email: " + subject);
            cb(null);
        }
        else {
            try {
                transporter.sendMail(mailOptions, function (error, info) {
                    if (error) {
                        cb(error.message);
                    }
                    else {
                        cb(null);
                    }
                });
            }
            catch (error) {
                cb(error.message);
            }
        }
    }
}
exports.sendEmail = sendEmail;
function notify(msg, device) {
    if (device === void 0) { device = null; }
    if (device != null) {
        msg = 'Device \'' + device.name + '\' (' + device.address + ') ' + msg;
    }
    log(msg);
    Config.findOne({}, function (err, config) {
        sendEmail(msg, '', config, function (error) {
            if (error) {
                log("Error sending email: " + error);
                return;
            }
        });
    });
}
exports.notify = notify;
function sortVersions(versions) {
    versions.sort(function (a, b) {
        var v1 = a.replace("wispswitch-", "").replace(".bin", "").replace("rc", ".");
        var v2 = b.replace("wispswitch-", "").replace(".bin", "").replace("rc", ".");
        var v1parts;
        var v2parts;
        v1parts = v1.split('.');
        v2parts = v2.split('.');
        while (v1parts.length < v2parts.length)
            v1parts.push("99");
        while (v2parts.length < v1parts.length)
            v2parts.push("99");
        v1parts = v1parts.map(Number);
        v2parts = v2parts.map(Number);
        for (var i = 0; i < v1parts.length; ++i) {
            if (v2parts.length == i) {
                return -1;
            }
            if (v1parts[i] == v2parts[i]) {
                continue;
            }
            else if (v1parts[i] > v2parts[i]) {
                return -1;
            }
            else {
                return 1;
            }
        }
        if (v1parts.length != v2parts.length) {
            return 1;
        }
        return 0;
    });
}
exports.sortVersions = sortVersions;
//# sourceMappingURL=util.js.map