/// <reference path="../typings/jquery/jquery.d.ts" />
/// <reference path="../typings/jquery.validation/jquery.validation.d.ts" />
/// <reference path="../typings/bootstrap/bootstrap.d.ts" />
/// <reference path="../typings/bootbox/bootbox.d.ts" />
/// <reference path="../typings/knockout/knockout.d.ts" />
/// <reference path="../typings/knockout.mapping/knockout.mapping.d.ts" />
/// <reference path="../typings/moment/moment.d.ts" />
var info;
var settings = {};
var tmpSettings = {};
var version = '';
var device_table_sort_column = "address";
var device_table_sort_inverse = false;
var Humanize;
var updateVersion = null;
var reloadDevicesTimer = null;
$(document).ready(function () {
    setDateTime();
    setInterval(setDateTime, 1000);
    // check to make sure we are authenticated, otherwise bump to the login page
    $.ajax({
        type: "GET",
        url: "/api/version",
        dataType: "json",
        success: function (data) {
            version = data.version;
            $("#version").text(version);
            if (data.crash_log) {
                $('#crash_log_alert').slideDown();
            }
        },
        error: function () {
            window.location.href = "/";
        }
    });
    $("#DeviceTable th").click(function () {
        var col = $(this).text().replace(" ", "_").toLowerCase();
        if (col != '') {
            if (col == device_table_sort_column) {
                device_table_sort_inverse = !device_table_sort_inverse;
            }
            else {
                device_table_sort_inverse = false;
            }
            sortDevices(col, device_table_sort_inverse);
            device_table_sort_column = col;
        }
    });
    $.ajax({
        type: "GET",
        url: "/api/devices",
        dataType: "json",
        success: function (data) {
            var mapping = {
                'devices': {
                    key: function (data) {
                        return ko.utils.unwrapObservable(data.id);
                    }
                },
                'schedules': {
                    key: function (data) {
                        return ko.utils.unwrapObservable(data._id);
                    }
                },
                'firmwares': {
                    key: function (data) {
                        return ko.utils.unwrapObservable(data._id);
                    }
                }
            };
            info = ko.mapping.fromJS(data, mapping);
            ko.applyBindings(info, document.getElementById('DeviceTable'));
            sortDevices("address", false);
            $.ajax({
                type: "GET",
                url: "/api/schedules",
                dataType: "json",
                success: function (data) {
                    ko.mapping.fromJS(data, info);
                    ko.applyBindings(info, document.getElementById('ScheduleTable'));
                    function schedules_changed() {
                        if (info.schedules().length == 0) {
                            $('#ScheduleBadge').hide();
                        }
                        else {
                            $('#ScheduleBadge').text(info.schedules().length);
                            $('#ScheduleBadge').show();
                            animateCss('ScheduleBadge', 'bounce');
                        }
                    }
                    info.schedules.subscribe(schedules_changed, null, 'arrayChange');
                    if (info.schedules().length > 0) {
                        $('#ScheduleBadge').text(info.schedules().length);
                        $('#ScheduleBadge').show();
                    }
                }
            });
            $.ajax({
                type: "GET",
                url: "/api/firmwares",
                dataType: "json",
                success: function (data) {
                    ko.mapping.fromJS(data, info);
                    ko.applyBindings(info, document.getElementById('FirmwaresTable'));
                }
            });
            reloadDevicesTimer = setInterval(reloadDevices, 1000);
        }
    });
    // this makes sure validation messages appear in the correct place when used with bootstrap
    jQuery.validator.setDefaults({
        highlight: function (element) {
            $(element).closest('.form-group').addClass('has-error');
        },
        unhighlight: function (element) {
            $(element).closest('.form-group').removeClass('has-error');
        },
        errorElement: 'span',
        errorClass: 'help-block',
        errorPlacement: function (error, element) {
            if (element.parent('.input-group').length) {
                error.insertAfter(element.parent());
            }
            else {
                error.insertAfter(element);
            }
        }
    });
    jQuery.validator.addMethod("pattern", function (value, element, param) {
        if (this.optional(element)) {
            return true;
        }
        if (typeof param === "string") {
            param = new RegExp("^(?:" + param + ")$");
        }
        return param.test(value);
    }, "Invalid format.");
    jQuery.validator.addMethod("hostname", function (value, element) {
        return this.optional(element) || /^([a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?\.)+[a-zA-Z]{2,6}$|^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3}(\/([0-9]+|(255|254|252|248|240|224|192|128|0)\.(255|254|252|248|240|224|192|128|0)\.(255|254|252|248|240|224|192|128|0)\.(255|254|252|248|240|224|192|128|0)))?$|((^|:)([0-9a-fA-F]{0,4})){1,8}$/.test(value);
    }, "Please enter a valid IP address or hostname");
    $('.modal').on('shown.bs.modal', function () {
        $('[autofocus]').focus();
    });
    $("#selectall").click(function () {
        $(".deviceselect").prop('checked', $("#selectall").prop('checked'));
    });
});
function setDateTime() {
    $("#CurrentTime").text(moment().format('lll'));
}
function formatDate(n) {
    return new Date(n).toLocaleString().replace(",", "");
}
function pad(num, size) {
    var s = num + "";
    while (s.length < size)
        s = "0" + s;
    return s;
}
function formatUptime(seconds) {
    seconds = Math.floor(seconds);
    if (seconds <= 0) {
        return '';
    }
    var years = 0;
    while (seconds > 31536000) {
        years++;
        seconds -= 31536000;
    }
    var days = 0;
    while (seconds > 86400) {
        days++;
        seconds -= 86400;
    }
    var hours = 0;
    while (seconds > 3600) {
        hours++;
        seconds -= 3600;
    }
    var minutes = 0;
    while (seconds > 60) {
        minutes++;
        seconds -= 60;
    }
    var output = '';
    if (years > 0) {
        if (years == 1) {
            output += years + " year ";
        }
        else {
            output += years + " years ";
        }
    }
    if (days > 0) {
        if (days == 1) {
            output += days + " day ";
        }
        else {
            output += days + " days ";
        }
    }
    output += pad(hours, 2) + ":" + pad(minutes, 2) + ":" + pad(seconds, 2);
    return output;
}
function getDeviceName(id) {
    var devices = info.devices();
    var i;
    for (i = 0; i < devices.length; i++) {
        if (devices[i].id() == id) {
            return devices[i].address();
        }
    }
    return '';
}
function reloadDevices() {
    $.ajax({
        type: "GET",
        url: "/api/devices",
        dataType: "json",
        timeout: 800,
        ifModified: true,
        success: function (data, status) {
            if (status == "success") {
                ko.mapping.fromJS(data, info);
                sortDevices(device_table_sort_column, device_table_sort_inverse);
            }
        },
        error: function (jqXHR) {
            if (jqXHR.status == 401) {
                window.location.href = "/";
            }
        }
    });
    $.ajax({
        type: "GET",
        url: "/api/schedules",
        dataType: "json",
        timeout: 800,
        ifModified: true,
        success: function (data, status) {
            if (status == "success") {
                ko.mapping.fromJS(data, info);
            }
        }
    });
    $.ajax({
        type: "GET",
        url: "/api/firmwares",
        dataType: "json",
        timeout: 800,
        ifModified: true,
        success: function (data, status) {
            if (status == "success") {
                ko.mapping.fromJS(data, info);
            }
        }
    });
    $.ajax({
        type: "GET",
        url: "/api/settings",
        dataType: "json",
        timeout: 800,
        ifModified: true,
        success: function (data, status) {
            if (status == "success") {
                if (updateVersion == null) {
                    if (data.last_seen_version != '' && data.last_seen_version != version) {
                        $("#About").addClass("notice");
                        $("#UpdateAvailable").show();
                        $(".UpdateVersion").text(data.last_seen_version);
                        updateVersion = data.last_seen_version;
                    }
                }
            }
        }
    });
}
function sortDevices(col, inverse) {
    info.devices.sort(function (left, right) {
        var leftval = left[col]();
        var rightval = right[col]();
        var result;
        if (col == 'address') {
            var a = ip2long(leftval);
            var b = ip2long(rightval);
            result = a == b ? 0 : (a < b ? -1 : 1);
        }
        else if (col == 'firmware') {
            var v1 = leftval.replace("rc", ".");
            var v2 = rightval.replace("rc", ".");
            var v1parts;
            var v2parts;
            v1parts = v1.split('.');
            v2parts = v2.split('.');
            while (v1parts.length < v2parts.length)
                v1parts.push("99");
            while (v2parts.length < v1parts.length)
                v2parts.push("99");
            v1parts = v1parts.map(Number);
            v2parts = v2parts.map(Number);
            for (var i = 0; i < v1parts.length; ++i) {
                if (v2parts.length == i) {
                    return inverse ? -1 : 1;
                }
                if (v1parts[i] == v2parts[i]) {
                    continue;
                }
                else if (v1parts[i] > v2parts[i]) {
                    return inverse ? -1 : 1;
                }
                else {
                    return inverse ? 1 : -1;
                }
            }
            if (v1parts.length != v2parts.length) {
                return inverse ? 1 : -1;
            }
            return 0;
        }
        else {
            result = leftval == rightval ? 0 : (leftval < rightval ? -1 : 1);
        }
        if (result != 0 && inverse) {
            if (result == 1) {
                return -1;
            }
            else {
                return 1;
            }
        }
        else {
            return result;
        }
    });
}
function ip2long(ip) {
    var pieces = ip.split('.');
    var longValue = pieces[0] * 0x1000000;
    longValue += pieces[1] * 0x10000;
    longValue += pieces[2] * 0x100;
    longValue += pieces[3] * 1;
    return longValue;
}
function getSelectedDevices() {
    var devices = [];
    $("#DeviceTable tr.info").each(function (index, tr) {
        devices.push(info.devices()[parseInt(tr.getAttribute("index"))]);
    });
    return devices;
}
function formatPPS(n) {
    var r = Humanize.compactInteger(n, 2) + "pps";
    r = r.replace(/([^0-9.])/, " $1");
    return r;
}
function formatBandwidth(n) {
    var tx = Humanize.fileSize(n).replace("B", "b").split(' ');
    return tx[0] + ' ' + tx[1] + 'ps';
}
function animateCss(id, animationName) {
    var animationEnd = 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend';
    $('#' + id).addClass('animated ' + animationName).one(animationEnd, function () {
        $('#' + id).removeClass('animated ' + animationName);
    });
}
//# sourceMappingURL=Frontend.js.map