"use strict";
var tungus = require('tungus');
var mongoose = require('mongoose');
;
var DeviceInfoSchema = new mongoose.Schema({
    address: { type: String, required: true, validate: /^([a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?\.)+[a-zA-Z]{2,6}$|^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3}$|((^|:)([0-9a-fA-F]{0,4})){1,8}$/ },
    username: { type: String, required: true },
    password: { type: String, required: true },
    ssh_port: { type: Number, required: true, default: 22 },
    web_port: { type: String, default: '' },
    monitor: { type: Boolean, default: true },
    name: { type: String, default: '' },
    model: { type: String, default: '' },
    firmware: { type: String, default: '' },
});
var DeviceInfo = mongoose.model("DeviceInfo", DeviceInfoSchema);
module.exports = DeviceInfo;
//# sourceMappingURL=DeviceInfo.js.map