"use strict";
var tungus = require('tungus');
var mongoose = require('mongoose');
var crypto = require('crypto');
;
var ConfigSchema = new mongoose.Schema({
    username: { type: String, required: true },
    password: { type: String, required: true },
    smtp_host: { type: String, default: '' },
    smtp_port: { type: Number, default: 25 },
    smtp_username: { type: String, default: '' },
    smtp_password: { type: String, default: '' },
    smtp_secure: { type: Boolean, default: false },
    smtp_to_address: { type: String, default: '' },
    smtp_from_address: { type: String, default: '' },
    smtp_local_hostname: { type: String, default: '' },
    latest_firmware: { type: String, default: '' },
    last_seen_version: { type: String, default: '' },
    log_expire_days: { type: Number, default: 7 },
});
ConfigSchema.pre('save', function (next) {
    var config = this;
    if (config.isModified('password')) {
        config.password = crypto.createHash('md5').update(config.password).digest('hex');
    }
    if (config.isModified('smtp_password')) {
        // we need to get the cleartext back later, so we can't hash this
        config.smtp_password = new Buffer(config.smtp_password).toString('base64');
    }
    return next();
});
var Config = mongoose.model("Config", ConfigSchema);
Config.prototype.comparePassword = function (candidatePassword) {
    var hash = crypto.createHash('md5').update(candidatePassword).digest('hex');
    return hash == this.password;
};
module.exports = Config;
//# sourceMappingURL=Config.js.map