"use strict";
var fs = require('fs-extra');
var cp = require('child_process');
var targz = require('tar.gz');
var child = null;
var updateCheckTimer = null;
function restartApp() {
    child.kill();
    if (fs.existsSync("update.tar.gz")) {
        targz().extract('update.tar.gz', '.', function (err) {
            if (err) {
                console.log('Error extracting update: ', err.stack);
            }
            fs.unlinkSync("update.tar.gz");
            if (process.env.NODE_ENV == 'production') {
                fs.copy("./opt/netonix-manager", ".", function (err) {
                    fs.remove("./opt");
                    startApp();
                });
            }
            else {
                // this is for testing
                fs.remove("./opt");
                startApp();
            }
        });
    }
    else {
        startApp();
    }
}
function startApp() {
    var crashlog = "";
    console.log("starting child process");
    var exe = "node";
    // on ubuntu the node executable is nodejs
    if (fs.existsSync("/usr/bin/nodejs")) {
        exe = "nodejs";
    }
    child = cp.spawn(exe, ['app.js']);
    child.stdout.setEncoding('utf8');
    child.stdout.on('data', function (data) {
        console.log(data.toString().trim());
    });
    child.stderr.on('data', function (data) {
        crashlog += data;
    });
    child.on('close', function (code) {
        console.log('process exit code ' + code);
        // if the app unexpectedly exits then restart it
        if (!fs.existsSync("update.tar.gz")) {
            fs.appendFileSync("crash.log", crashlog);
            clearInterval(updateCheckTimer);
            startApp();
        }
    });
    updateCheckTimer = setInterval(function () {
        if (fs.existsSync("update.tar.gz")) {
            clearInterval(updateCheckTimer);
            restartApp();
        }
    }, 5000);
}
startApp();
//# sourceMappingURL=bootloader.js.map